procedure(const aTekst: string)
begin
  WriteLn(aTekst);
end

// -----------------------------------------------------------------------------

type
  TProceduraWyjciowa = reference to procedure(const aTekst: string);

ProceduraWyjciowa := procedure(const aTekst: string)
                      begin
                        WriteLn(aTekst);
                      end;

// -----------------------------------------------------------------------------

procedure PrzetwarzajDane(aDane: TDane; Reporter: TProceduraWyjciowa);
begin
  ZweryfikujDane(aDane);
  WpiszDaneDoBazy(aDane);
  Reporter(aDane.Nazwa + ' przetworzone.');
end;

PrzetwarzajDane(MojeDane, procedure(const aTekst: string)
                          begin
                            ZapisDoDziennika(aTekst);
                          end);

// -----------------------------------------------------------------------------

type
  TKalkulator = class
    function Dodaj(x, y: integer): integer;
    function Odejmij(x, y: integer): integer;
  end;

{...}

function TKalkulator.Dodaj(x, y: integer): integer;
begin
  Result := x + y;
end;

function TKalkulator.Odejmij(x, y: integer): integer;
begin
  Result := x - y;
end;

// -----------------------------------------------------------------------------

type
 TFunkcjaCakowita = reference to function(const x, y: integer): integer;

  TProstyKalkulator = class
  strict private
    FLista: TDictionary<string, TFunkcjaCakowita>;
    procedure ZarejestrujOperatory;
  public
    constructor Utwrz;
    procedure ZarejestrujOperatorMatematyczny(aNazwa: string;
                                              aDziaanie: TFunkcjaCakowita);
   function Oblicz(aNazwa: string; x, y: integer): integer;
  end;

{...}

function TProstyKalkulator.Oblicz(aNazwa: string; x, y: integer): integer;
begin
 Result := FLista[aNazwa](x, y);
end;

constructor TProstyKalkulator.Utwrz;
begin
  inherited;
  FLista := TDictionary<string, TFunkcjaCakowita>.Create;
  ZarejestrujOperatory;
end;

procedure TProstyKalkulator.ZarejestrujOperatory;
begin
  ZarejestrujOperatorMatematyczny('Dodaj', function(const x, y: integer): integer
                                           begin
                                             Result := x + y;
                                           end);
  ZarejestrujOperatorMatematyczny('Odejmij', function(const x, y: integer): integer
                                             begin
                                               Result := x - y;
                                             end);
  ZarejestrujOperatorMatematyczny('Przemn', function(const x, y: integer): integer
                                              begin
                                                Result := x * y;
                                              end);
end;

procedure TProstyKalkulator.ZarejestrujOperatorMatematyczny(aNazwa: string;
                                        aDziaanie: TFunkcjaCakowita);
begin
  FLista.Add(aNazwa, aDziaanie);
end;

// -----------------------------------------------------------------------------

function Potgowanie(x, y: integer): integer;
begin
  if y = 0 then
  begin
    Result := 1;
  end else
  begin
    Result := x * Potgowanie(x, y - 1);
  end;
end;

{...}

MjKalkulator.ZarejestrujOperatorMatematyczny('Potguj',
                                              function(const x, y: integer): integer
                                              begin
                                                Result := Potgowanie(x, y);
                                              end);

// -----------------------------------------------------------------------------

var
  Odejmowanie: TFunkcjaCakowita;
begin
  Odejmowanie := function(const x, y: integer): integer
                 begin
                   Result := x - y;
                 end;
  ZarejestrujOperatorMatematyczny('Odejmij', Odejmowanie);
end;

// -----------------------------------------------------------------------------

function DodajLiczby(a, b: integer): integer;
var
  Dodawanie: TFunc<integer, integer, integer>;
begin
  Dodawanie:= function(x, y: integer): integer
              begin
                Result := x + y;
              end;
  Result := Dodawanie(a, b);
end;

// -----------------------------------------------------------------------------

begin
  StaryKursor := PobierzBiecyKursor;
  try
    Kursor := crHourglass;
    // Dugotrway proces, podczas ktrego wywietlany jest kursor w postaci klepsydry
  finally
    Kursor := StaryKursor
  end;
end;

// -----------------------------------------------------------------------------

procedure PokaKlepsydr(Procedura: TProc);
var
  StaryKursor: TCursor;
begin
  StaryKursor := Screen.Cursor;
  Screen.Cursor := crHourGlass;
  try
    Procedura;
  finally
    Screen.Cursor := StaryKursor
  end;
end;

PokaKlepsydr(procedure
               var
                 i: integer;
               begin
                 for i := 1 to 99999999 do;
               end);

// -----------------------------------------------------------------------------

type
  Obiekt = class
    class procedure Using<T: class>(O: T; Procedura: TProc<T>); static;
 end;

class procedure Obiekt.Using<T>(O: T; Procedura: TProc<T>);
begin
  try
    Procedura(O);
  finally
    O.Free;
  end;
end;

Obiekt.Using<TStringList>(TStringList.Create, procedure(Lista: TStringList)
begin
  Lista.Add('Jeden');
  Lista.Add('Dwa');
  Lista.Add('Trzy');
  Lista.Add('Cztery');
  PoleListy.Items := Lista;
end);

// -----------------------------------------------------------------------------

type
  TZdarzenie = procedure(Nadawca: TObject) of object;

property OnClick: TZdarzenie read FPoKlikniciu write FPoKlikniciu;

procedure WykonajPoKlikniciu;
begin
  if Assigned(FPoKlikniciu) then FPoKlikniciu(Self);
end;

// -----------------------------------------------------------------------------

var
  MniejszeOd10: TPredicate<integer>;
begin
  MniejszeOd10 := function( aWarto: integer): Boolean
                  begin
                    Result := aWarto < 10;
                  end;
  {...}
end;

// -----------------------------------------------------------------------------

procedure SprawdCzyMniejszeOd10;
var
  MniejszeOd10: TPredicate<integer>;
  i: integer;
begin
  MniejszeOd10 := function(aWarto: integer): Boolean
                  begin
                    Result := aWarto < 10;
                  end;
  Write('Podaj liczb cakowit: ');
  Readln(i);

  if MniejszeOd10(i) then
  begin
    WriteLn(i, ' jest mniejsze od 10');
  end else
  begin
    WriteLn(i, ' jest wiksze lub rwnie 10');
  end;
end;

// -----------------------------------------------------------------------------

procedure PodzielnePrzez7;
var
  i: Integer;
begin
  for i := 1 to 100 do
  begin
    if i mod 7 = 0 then
    begin
      Write(i, ', ');
    end;
  end;
  WriteLn;
end;

// -----------------------------------------------------------------------------

procedure WywietlLiczby(aZakwalifikowana: TPredicate<integer>);
var
  i: Integer;
begin
  for i := 1 to 100 do
  begin
    if aZakwalifikowana(i) then
    begin
      Write(i, ', ');
    end;
  end;
  WriteLn;
end;

// -----------------------------------------------------------------------------

procedure ZnajdLiczby;
var
  PodzielnaPrzez7: TPredicate<integer>;
  MniejszaOd25PodzielnaPrzez2: TPredicate<integer>;
begin

  PodzielnaPrzez7 := function(aLiczba: integer): Boolean
                      begin
                        Result := aLiczba mod 7 = 0;
                      end;
  WywietlLiczby(PodzielnaPrzez7);

  MniejszaOd25PodzielnaPrzez2 := function(aLiczba: integer): Boolean
                                 begin
                                   Result := (aLiczba < 25) and (aLiczba mod 2 = 0);
                                 end;
  WywietlLiczby(MniejszaOd25PodzielnaPrzez2);

end;

// -----------------------------------------------------------------------------

begin
  UtwrzWidet(procedure(aWidet, aGeneratorWidetw)
                 begin aGeneratorWidetw.PrzygotujWidet(aWidet)
               end);
end;
